CFLAGSBOOT   := $(CDBG) -mn    -mt    -c $(CFLAGS)

#Where to place the library file - if any
LIB_BOOT     := ti/lib/bootloader$(NBRD).lib

#Add to this
CFG_LIBS     += $(LIB_BOOT)

ASM_BOOT     += ti/bootloader/src/bootloader.s ti/bootloader/src/branch_in_RAM.s ti/drv/common/int.s
SRC_BOOT     += ti/bootloader/src/cmdboot.c ti/bootloader/src/command.c ti/bootloader/src/convert.c\
  ti/bootloader/src/optboot.c ti/bootloader/src/serial.c ti/bootloader/src/start.c

OBJ_ASM_BOOT := $(patsubst %.s,%.obj,$(filter %.s,$(ASM_BOOT)))
OBJ_BOOT     := $(patsubst %.c,%.obj,$(filter %.c,$(SRC_BOOT)))
CFG_OBJS     += $(OBJ_BOOT) $(OBJ_ASM_BOOT)
CFG_DEPS     += $(SRC_BOOT:.c=.d)

$(LIB_BOOT) : $(OBJ_BOOT) $(OBJ_ASM_BOOT)
	ar470 r $(LIB_BOOT) $(OBJ_BOOT) $(OBJ_ASM_BOOT)

$(OBJ_BOOT) : %.obj: %.c
	cl470 $(CFLAGSBOOT)  -fr$(@D) $<

ti/bootloader/src/branch_in_RAM.obj : %.obj : %.s
	asm470 $(ASMFLAGS16) $(ADEFS) $< $@

