TI_MODULES     := ti/bootloader ti/drv ti/l1_al/tpu ti/ffs

BT_MODULES := \
blaatand/Board/trace\
blaatand/Common/bte\
blaatand/Common/Sdp\
blaatand/Common/hsg\
blaatand/Common/atp\
blaatand/Common/Btctrl\
blaatand/Board/drv
#blaatand/Common/Rfcomm\
#blaatand/Common/L2cap\
#blaatand/Common/hci\
#blaatand/Common/BTF\
#blaatand/Common/spp

CONDAT_MODULES :=

OS_MODULES     :=

MODULES        := $(TI_MODULES) $(BT_MODULES)

#Module makefiles are named according to the last directory name given by TI_MODULES
#I.e. makefile for ti/bootloader is bootloader.mak
MKFILES  := $(join $(MODULES), $(addprefix /, $(notdir $(addsuffix .mak, $(MODULES)))))

#This is the directory relative to . where we place the configuration header files 
CONFIGDIR = config


#Bluetooth include directories
BT_INCLUDES := blaatand/Common/Btctrl blaatand/Common/General blaatand/Common/Hci blaatand/Board/Hcit \
               blaatand/Board/Main blaatand/Board/drv blaatand/Board/Nucleus_OS blaatand/Common/BTF \
               blaatand/Common/L2cap blaatand/Common/Rfcomm blaatand/Common/spp blaatand/Common/Test\
               blaatand/Common/atp blaatand/Common/hsg blaatand/Common/hs blaatand/Common/Sdp/SDP_Common \
               blaatand/Common/Sdp/SDP_Client blaatand/Common/Sdp/SDP_Server blaatand/Common/bte \
               blaatand/Board/trace

INCLUDES    := $(CONFIGDIR) ti/drv/common ti/drv/board_$(BOARD) os $(C_DIR) \
               ti/l1_al/l1_std/include ti/l1_al/l1_std/hint ti/l1_al/l1_cst \
               ti/l1_al/tpu/tpu_drivers1/source condat/com/include \
               ti/bootloader/inc condat/ms/src/l1 $(BT_INCLUDES)

#Option -g  : Symbolic debugging.
CDBG := -g

#Common for all compiling flags - CFG_CFLAGS comes from gsm.cfg
CFLAGS      := -eoobj -pw2 -mw -me $(patsubst %,-i%,$(INCLUDES)) $(CFG_CFLAGS)
CFLAGSBT    := -g $(CFG_CFLAGS) -me -mt -mn -pr

#Compiler flags for 16 bit compiling
CFLAGS16    := $(CDBG) -mn    -mt -o -c $(CFLAGS)

ASMFLAGS    := -me $(patsubst %,-i%,$(INCLUDES))
ASMFLAGS16  := $(ASMFLAGS) -mt

#BOARD environment variable is needed, since it is present in assembler file
ADEFS  :=   -dBOARD=$(BOARD)

CPPFLAGS += -MM $(patsubst %,-I%,$(INCLUDES)) -UWIN32 $(CPPWARN)

include ti/l1_al/l1_env.mak
include condat/condat_env.mak

export

#Include configuration management module makefiles 
include $(MKFILES)

# Include the automatically generated C include dependency makefiles 
-include $(CFG_DEPS)

# Calculate C include dependencies
$(CFG_DEPS) : %.d: %.c
	@echo Generating dependencies for "$<"
	@cpp $(CPPFLAGS) $< > $@
	@perl -w -p -i".tmp" -e "s@^\w+.o:@$<:@; s@^(.*)\.c:@$1.obj $1.d:@" $@
	@rm $@.tmp
