#define _LARGEFILE64_SOURCE 
#include<stdio.h>
#include<fcntl.h>
#include<stdlib.h>
#include<error.h>
#include<string.h>
#include<assert.h>
#include<sys/types.h>
#include<unistd.h>
#include"replaceAnnotated.h"
#include"fileIO.h"
#include"elf.h"
#include"elfOps.h"

#define NUM_MACROS 39
#define RSM_INDEX 28
#define SSM_INDEX 29
#define READ_CR_INDEX 30
#define WRITE_CR_INDEX 31

char * macroNames[NUM_MACROS] = {"start", "cover", "bsw_0", "bsw_1", "rfi", "ptc_e", "read_psr", "write_psr", "thash", "itc_i", "read_b2", "write_b2", "st8_spill", "ld8_fill", "ptc_e", "ptc_ga", "ptc_g", "ptc_l", "itr_i", "itr_d", "write_kr", "read_kr", "fc", "tpa", "itc_d", "ptr_i", "read_rr", "write_rr", "rsm", "ssm", "read_cr", "write_cr", "epc", "unepc", "write_itc", "srlz_d", "srlz_i", "ptr_d", "end"};



int alignTo8Bytes(int j)
{
        j =  (j - 1)/8;
        j = j +1;
        j = j * 8;
        return(j);
}

long alignTo16Bytes(long j)
{ 
	j =  (j - 1)/16;
        j = j +1;
        j = j * 16;
        return(j);

}



unsigned int findMatch(char * ptr)
{
        int k=0, j=0;
        unsigned int index = 0;
        for(k=0; k< NUM_MACROS; k++)
        {
                for(j=0; ptr[j]!='\0'; j++)
                {
                        if(ptr[j] != macroNames[k][j])
                        {
                                break;
                        }
                }
                if(ptr[j] == '\0')
                {
			if(macroNames[k][j] != '\0')
			{
				// ptr is a substring of macroNames[k]- we want a perfect string match
				continue;
			}
			else
			{
	                        printf("\n Match found with %s ", macroNames[k]);
        	                printf("\n Pointer contains : %s ", ptr);
                	        index= k;
                        	break;
			}
                }
                //printf("\n stored Macro is : %s \n", macroNames[k]);
        }
        assert(k!=NUM_MACROS); //there should be a match
        printf("\n returning index %d ",  index);
        return index;
}





int origFileD, replaceFileD;

replacementAnnot_t repAnnotation[NUM_MACROS];	

/* read the shdr.
 * find a match of macro string
 * fill in the appropriate addresses and lengths
 * and other annotated information in replacementAnnot.
*/
int getReplacementMacroAnnotation(Elf64_Shdr * shdr)
{
        char * ptr;
        unsigned int retVal = 0, i=0, j=0, m_index=0;
        ptr = (char *) malloc(shdr->sh_size);
        if(NULL == ptr)
        {
                return(-1);
        }
        retVal = lseek(replaceFileD, shdr->sh_offset, SEEK_SET);
        if(retVal < 0)
        {
                perror("\n Could not lseek to read the afterburn section:");
                return retVal;
        }
        retVal = read(replaceFileD, ptr, shdr->sh_size);
        if(retVal < 0)
        {
                perror("\n Could not read the afterburn section because: ");
                return retVal;
        }
        for(i=0; i<shdr->sh_size;)
        {
                printf("\n before findMatch, ptr contains : %s ", ptr);
                m_index = findMatch(ptr);
                printf("\n findMatch() returned val : %d ", m_index );
                if(m_index == (NUM_MACROS - 1))
                {
			printf("\n Section processed completely !");
                        break; //end macro case
                }
                if(m_index == 0)
                {
                        // case of start; 
                        assert(0); // xen_afterburn should not have "start"
                }
                printf("\n m_index is : %d ", m_index);
                for(j=0; ptr[j]!= '\0'; j++)
                {
                        repAnnotation[m_index].name[j] = ptr[j];
                }
                assert(j <= 10); //rigth now we have declared the name to be of max 10 char
		printf("\n repAnnotation[m_index].name: %s ", repAnnotation[m_index].name);
                printf("\n j is :%d ", j);
                j = j+1;
                j = alignTo8Bytes(j);
                printf("\n After alignment j is :%d ", j);
                i = i + j;
                ptr = ptr + j;
                repAnnotation[m_index].addr = (unsigned long) &__executable_start; //convert addresses to offsets.
                repAnnotation[m_index].addr = (*(unsigned long *) ptr) - repAnnotation[m_index].addr;
		printf("\n repAnnotation[m_index].addr: %lx ", repAnnotation[m_index].addr);
                assert(repAnnotation[m_index].addr > 0);
                i = i + 8;
                ptr = ptr + 8;
                repAnnotation[m_index].len = *(unsigned long *) ptr;
		printf("\n repAnnotation[m_index].len : %lu ", repAnnotation[m_index].len);
		assert(repAnnotation[m_index].len < 20);
                i = i + 8;
                ptr = ptr + 8;
                repAnnotation[m_index].num_args = *(unsigned long *) ptr;
		printf("\n repAnnotation[m_index].num_args: %lu ", repAnnotation[m_index].num_args);
                i = i + 8;
                ptr = ptr + 8;
                if(repAnnotation[m_index].num_args != 0)
                {
			int k;
			repAnnotation[m_index].instnNumAndArgs = (struct instn_args_annot *)malloc(sizeof(struct instn_args_annot));
			if(repAnnotation[m_index].instnNumAndArgs == NULL)
			{
				printf("\n Could not allocate memory to repAnnotation.instnNumAndArgs..Exiting ! \n");
				perror("\n Error: ");
				exit(0);
			}
			repAnnotation[m_index].instnNumAndArgs->instn_num =  (*(unsigned long *) ptr);
			i = i + 8;
			ptr = ptr + 8;	
			printf("\n repAnnotation[m_index].instnNumAndArgs->instn_num : %lu " , repAnnotation[m_index].instnNumAndArgs->instn_num);
			printf("\n repAnnotation[m_index].num_args : %lu ", repAnnotation[m_index].num_args );
			repAnnotation[m_index].instnNumAndArgs->args = (struct args *) malloc(sizeof(struct args) * repAnnotation[m_index].num_args);
			if(repAnnotation[m_index].instnNumAndArgs->args == NULL)
			{
				 printf("\n Could not allocate memory to  repAnnotation[m_index].instnNumAndArgs->args ... Exiting ! \n");
				 perror("\n Error: ");
				 exit(0);
			}
			for(k=0; k<repAnnotation[m_index].num_args; k++)
			{
				repAnnotation[m_index].instnNumAndArgs->args[k].type_of_arg = (*(unsigned long *) ptr);
				i = i + 8;
				ptr = ptr + 8;
				if(repAnnotation[m_index].instnNumAndArgs->args[k].type_of_arg == 2) //if type is INCR
				{
					int l=0;
					repAnnotation[m_index].instnNumAndArgs->args[k].total_bits = (*(unsigned long *) ptr);
					ptr = ptr + 8;
					i = i + 8; 
					for(l=0; l<repAnnotation[m_index].instnNumAndArgs->args[k].total_bits; )
					{	
						//actually you should be saving all the ranges. however since we wont be needing them in this 
						//program, we are actually overwriting them. Should make the necessary changes as and when needed
						repAnnotation[m_index].instnNumAndArgs->args[k].start_bit = (*(unsigned long *) ptr);
						i = i + 8;
						ptr = ptr + 8;
						repAnnotation[m_index].instnNumAndArgs->args[k].num_bits = (*(unsigned long *) ptr);
       		        	        	i = i + 8;
	       	        		        ptr = ptr + 8;
						l = l+repAnnotation[m_index].instnNumAndArgs->args[k].num_bits;
					}
				}
				else
				{
					repAnnotation[m_index].instnNumAndArgs->args->start_bit = (*(unsigned long *) ptr);
					ptr = ptr + 8;
					i = i + 8;
					repAnnotation[m_index].instnNumAndArgs->args->num_bits = (*(unsigned long *) ptr);
					ptr = ptr + 8;
					i = i + 8;
				}
			}
                }
        }
        return retVal;
}


typedef struct origInstnAnnot  //for the time being this shall be the xen code and contains the original instn. 
{
	char name[15];
	unsigned long addr;
	unsigned long len;
	unsigned long num_args;
	unsigned char orig_instn[16];  //we copy the entire bundle and replace the entire bundle
}xen_Annot_t;

xen_Annot_t xenCurrentInstn_Annot;

//prepareSensitiveInst - currently shall prepare the senstive instrn for replacing the xen code with the neutral code.
//  prepareSensitiveInstn( shdr,  &ptr, &m_index, &i) 

unsigned long prepareSensitiveInstn(char ** ptr,  uint *m_index, uint * i_increment)
{
        char * origContents;
        int j =0;
        unsigned long retVal = 0;
        origContents = (char *)NULL;
        printf("\n***\n");
        printf("\n Name of the macro : %s ", (char *)*ptr);
        printf("\n Start: %lx \n", *(((unsigned long*) *ptr) + 1));
        assert(strlen(*ptr) < 15); //right now we are assumign this. 
	assert(strlen(*ptr) > 0);
        for(j = 0;((char *)(*ptr))[j] != '\0'; j++)
        {
                xenCurrentInstn_Annot.name[j] = ((char *)(*ptr))[j];
        }
        *m_index= findMatch(*ptr);
	if(*m_index == (NUM_MACROS -1))
	{
		printf("\n All the sensitive instructions are processed ! \n");
		return(-1);
	}
        j = j+ 1; /* now j is past the '\0' */
        printf("\n j is: %d ", j);
        j = alignTo8Bytes(j);
         /* now j is aligned to the next 8 byte boundary*/
        *i_increment = (*i_increment) + j;
        *ptr = *ptr + j;
        printf("\n j is: %d ", j);
        xenCurrentInstn_Annot.addr = *((unsigned long*) *ptr);
        printf("\n Start Addr : %lx \n", xenCurrentInstn_Annot.addr);
        printf("\n ................................\n");
        *i_increment = (*i_increment) + 8;
        *ptr = *ptr + 8;
        if(0 == *m_index) //for vmlinux this would not arise
        {
		// printf("\n There is no start put in this file ");
		// assert(0); 
        	printf("\n Start Addr : %lx \n", xenCurrentInstn_Annot.addr);
                retVal = xenCurrentInstn_Annot.addr; //start of external file
		printf("\n retVal is : %lx", retVal);
                printf("\n returning from prepareSensitiveInstn ");
        }
        else
        {
                //printf("\n Index_offset: %d , repAnnotation[*m_index].addr: %lx ", (int)*m_index, repAnnotation[*m_index].addr);
                //printf("\n Number of args is : %lx ", repAnnotation[*m_index].num_args);
                //printf("\n Length: %lx \n", *((unsigned long*) *ptr));
                xenCurrentInstn_Annot.len = *((unsigned long*) *ptr);
		printf("\n xenCurrentInstn_Annot.len : %lx ", xenCurrentInstn_Annot.len);
                assert(xenCurrentInstn_Annot.len != 0);
                *i_increment = (*i_increment) + 8;
                *ptr = *ptr + 8;
                printf("\n num of args: %lx \n", *((unsigned long*) *ptr));
                xenCurrentInstn_Annot.num_args = *((unsigned long*) *ptr);
		printf("\n xenCurrentInstn_Annot.num_args: %lx ", xenCurrentInstn_Annot.num_args);
                *i_increment = (*i_increment) + 8;
                *ptr = *ptr + 8;
                if(xenCurrentInstn_Annot.len > (repAnnotation[*m_index].len))
		{
                        printf("\n xenCurrentInstn_Annot.len = %lx , repAnnotation[*m_index].len = %lx ", xenCurrentInstn_Annot.len, (repAnnotation[*m_index].len));
                        printf("\n The length of the nops in the neutral code and the replacement code is not the same !\n ");
                        close(origFileD);
                        close(replaceFileD);
                        exit(0);
                }
		printf("\n value of i is : %d ", *i_increment);
		if(xenCurrentInstn_Annot.num_args > 0)
		{
			int z=0;
			*ptr = *ptr + 1;
			j = (char *)alignTo16Bytes(*ptr) - *ptr;
			*ptr = *ptr + j;
			*i_increment = (*i_increment) + j;
			memcpy(xenCurrentInstn_Annot.orig_instn, *ptr, 16); //copy the entire bundle
			*i_increment = (*i_increment) + 16;
			*ptr = *ptr + 16;
		}
        }
	printf("\n returning : %lx ", retVal);
        return  retVal;
}

/* we need to overwrite the sensitive instruction stored with the one
stored in the afterburn section of xen */
#define NUM_BITS_INSTN 41

void overwriteSensitiveInstnBundle(unsigned char ** replaceWith, unsigned long instn_num)
{
	int i=0;
	print(xenCurrentInstn_Annot.orig_instn, "stored instruction in orig file: ");
	memcpy(*replaceWith, xenCurrentInstn_Annot.orig_instn, 16);
}


void print(unsigned char * ptr, char * str)
{
	int i=0;
	printf("\n Contents of : %s ", str);
	for(i=0; i<16; i++)
	{	
		printf("%x ", *(ptr + i));
	}
	
}

int copyRemainingInstnsFromOrigCode(unsigned char *replaceWith, unsigned char *origContents, unsigned int free_instns, unsigned int bundle_num)
{
	unsigned long mask = 0;
	unsigned int skip_num_bytes = 0;
	int i =0;
	// copy the instructions which merge with the rest of the code preceeding the bundle	
	skip_num_bytes = bundle_num * 16; //number of bytes in a bundle is 16
	// we have read skip_num_longs + 1 bundle.
	printf("\n skip_num_bytes : %lx ", skip_num_bytes);
	replaceWith = replaceWith + skip_num_bytes ;
	origContents = origContents + skip_num_bytes ;
	switch(free_instns)
	{
		case 1:
			//maintain the first 5 bits of the original code as these are the template bits
			//get the last two instructions from origContents and copy it onto replaceWith
			printf("\n Only one free instruction. So copying the last two instructions from the orig code \n");
			print(origContents, "origContents initially");
			print(replaceWith,  "replaceWith initially ");
			mask = (((unsigned long)~0) << 46) | ~(((unsigned long)~0) << 5); // 5 bits for the template info
			printf("\n mask is : %lx ", mask);
			(*(unsigned long *) origContents) &= mask;
			print(origContents, "origContents after anding with masking");
			(*(unsigned long *) replaceWith)  &= ~mask;
			print(replaceWith, "replaceWith after anding with ~mask");
			for(i=0 ;i<8; i=i+1)
			{
				*(replaceWith + i) |= *(origContents+i);
			}
			for(i=8 ;i<16; i=i+1)
			{
				*(replaceWith + i) = *(origContents+i);
			}
			print(replaceWith, "replaceWith- final stage");
			break;
		case 2:
			//maintain the first 5 bits of the original code as these are the template bits
			mask = ~(((unsigned long)~0) << 5); // all 1's in the first 5 bits for the template info
			* ((unsigned long *) origContents) = (*(unsigned long *) origContents) & mask;
			* ((unsigned long *) replaceWith)  = (* (unsigned long*) replaceWith) & ~mask;
			for(i=0 ;i<8; i=i+1)
			{
				*(replaceWith + i) = (*(replaceWith+i) | *(origContents+i));
			}
			//get the last one instruction from the origContents and copy it onto replaceWith
			printf("\n Two free instruction. So copying the last one instruction from the orig code \n");
			mask = ((unsigned long)~0) << 23;
			* (unsigned long *) (origContents+ 8) = (*(unsigned long *)(origContents+ 8)) & mask;
			* (unsigned long *) (replaceWith + 8) = (*(unsigned long *)(replaceWith + 8)) & ~mask;
			for(i=8 ;i<16; i=i+1)
			{
				*(replaceWith + i) = (*(replaceWith+i) | *(origContents+i));
			}
			break;
		default:
			printf("\n Remaining num of instructions is wrong ! some error !! ..quiting\n");
			close(origFileD);
			close(replaceFileD);
			assert(0);
			break;
	}
}



/* this function should replace the sensitive instruction in the replacement 
code with the sensitive instruction stored in the afterburn section
of the original xen code. This needs to be done so as to use the original
operands. So instead of fetching the operands and replacing them, we 
store the entire instruction in the replacement code 

2) we read and write integral bundles, not isntruction by isntruction because,
the bundle/template information might be totally different. Since we can overwrite
that because of the complete bundle replacement, it is ok. However, when we need
to overwrite instructions in a bundle, and not complete bundles, we need to preserve
the template format.

3) We assume here that the sensitive instruction is always in the first bundle.
prepareReplacementCode(&replaceWith, m_index, start_extFile) ;
*/

int prepareReplacementCode(uchar ** replaceWith, unsigned char m_index, unsigned long start_extFile)
{
        int sizeOfInstns, bundle_num = 0, free_instns=0;
	unsigned long instn_num = 0 ; 
        uchar * origContents;
	printf("\n Inside prepareReplacementCode \n");
	printf("\n About to call lseekAndReadReplacementCode for xenCurrentInstn_Annot.len: %d", xenCurrentInstn_Annot.len);
	assert(m_index < NUM_MACROS);
	if((sizeOfInstns = lseekAndReadReplacementCode(replaceWith, replaceFileD, xenCurrentInstn_Annot.len,  m_index)) < 0)
        {
		printf("\n lseekAndReadReplacementCode could not read/lseek ..so quitting \n");
		perror(" Reason: ");
                close(origFileD);
                close(replaceFileD);
                exit(0);
        }
	print(*replaceWith, "replaceWith just read: ");
	printf("\n Size of instructions is : %d ", sizeOfInstns);
	assert(sizeOfInstns % 16 == 0);  //we are reading in bundles, size of one bundle is 16 bytes
	bundle_num = xenCurrentInstn_Annot.len/3;
	free_instns = xenCurrentInstn_Annot.len%3;
       	if(lseekAndReadOrigFile(&origContents, origFileD, ((xenCurrentInstn_Annot.addr & (~(unsigned long)0<<2)) - start_extFile), sizeOfInstns) < 0)
       	{	
		printf("\n lseekAndReadOrigFile could not read/lseek ..so quitting \n");
		perror(" Reason: ");
		close(origFileD);
		close(replaceFileD);
		exit(0);
	}
	print(origContents , "origContents just read: ");
	if(xenCurrentInstn_Annot.num_args > 0)
	{
		instn_num = repAnnotation[m_index].instnNumAndArgs->instn_num; //insnt num is only stored when there are some args to be replaced
		// in case of taged address, the last two bits are set. However the bundle address starts at an address when these two bits are zero
		// for a tag address the last two bits indicate the slot number in a instruction
	  	if(bundle_num > 0)
		{
			print(replaceWith, " replaceWith before overwriting ");		
			overwriteSensitiveInstnBundle(replaceWith, instn_num);
			if(free_instns > 0)
			{
				
				copyRemainingInstnsFromOrigCode(*replaceWith, origContents, free_instns, bundle_num);
			}
			print(*replaceWith, "replaceWith after overwriting ");		
		}
		else
		{
		 	// unsigned long slot_num = 0;
			int i=0;
			int slot_num = repAnnotation[m_index].addr & 0x03;
			unsigned long mask=0;
			unsigned long temp = 0, temp1=0;
			assert(free_instns == 1);
			// only one instruction to be copied
        		printf("\n replace Instn initially contains : ");
		        for(i=0; i<16; i=i+4)
		        {
		                printf("%x %x %x %x ", (*replaceWith)[i], (*replaceWith)[i+1], (*replaceWith)[i+2] ,(*replaceWith)[i+3]);
			}
			printf("\n Slot num is : %x \n", slot_num);
			switch(slot_num)
			{
				case 0:
					copyRemainingInstnsFromOrigCode(replaceWith, &origContents, 1, 0); //bundle_num = 0 and free_instns = 1
					break;
				case 1:
					//copy the first instn and the template info from the orig code.
					mask = (~(unsigned long)0)<< 46;
					**replaceWith =  *((unsigned long *)*replaceWith) & mask;
					**replaceWith =  *((unsigned long *)*replaceWith) | ((*(unsigned long *)origContents) & ~mask);
					//copy the third instn from the orig code
					mask = (~(unsigned long)0)<< 23;
					*(unsigned long *)(*replaceWith + 8) =  *((unsigned long *)(*replaceWith + 8)) & ~mask;
					*(unsigned long *)(origContents + 8 ) = (*(unsigned long *)(origContents + 8)) & mask;
					*(unsigned long *)(*replaceWith + 8)= *((unsigned long *)(*replaceWith + 8)) | (*(unsigned long *)(origContents+ 8));
					break;
				case 2:
					//copy the first and second instn from the origcode
					**replaceWith = (*(unsigned long *)origContents);	
					mask = (~(unsigned long)0)<< 23;
					*(unsigned long *)(*replaceWith + 8) =  (unsigned long ) (*((unsigned long *)(*replaceWith + 8)) & mask);
					*(unsigned long *)(origContents + 8 ) = (*(unsigned long *)(origContents + 8)) & ~mask;
					*(unsigned long *)(*replaceWith + 8)= *((unsigned long *)(*replaceWith + 8)) | (*(unsigned long *)(origContents+ 8));
					break;
				default:
					//should never aris
					printf("\n Should never arise...wrong tag address obtained ??\n" );
					assert(0);
					break;	
			}

		}
	
	}
	else
	{
	// copy the replacement code to the original code.
		if(bundle_num > 0)
		{
			if(free_instns == 0)
			{
				print(*replaceWith, "replaceWith - orig and final : ");
				printf("\n No arguments, so blindly overwriting ");
			}
			else
			{
				copyRemainingInstnsFromOrigCode(replaceWith, &origContents, free_instns, bundle_num);
			}
		}
		else
		{
			int i=0;
			int slot_num = repAnnotation[m_index].addr & 0x03;
			unsigned long mask=0;
			unsigned long temp = 0, temp1=0;
			// only one instruction to be copied
        		printf("\n replace Instn initially contains : ");
		        for(i=0; i<16; i=i+4)
		        {
		                printf("%x %x %x %x ", (*replaceWith)[i], (*replaceWith)[i+1], (*replaceWith)[i+2] ,(*replaceWith)[i+3]);
			}
			printf("\n Slot num is : %x \n", slot_num);
			switch(slot_num)
			{
				case 0:
					copyRemainingInstnsFromOrigCode(replaceWith, &origContents, 1, 0); //bundle_num = 0 and free_instns = 1
					break;
				case 1:
					//copy the first instn and the template info from the orig code.
					mask = (~(unsigned long)0)<< 46;
					**replaceWith =  *((unsigned long *)*replaceWith) & mask;
					**replaceWith =  *((unsigned long *)*replaceWith) | ((*(unsigned long *)origContents) & ~mask);
					//copy the third instn from the orig code
					mask = (~(unsigned long)0)<< 23;
					*(unsigned long *)(*replaceWith + 8) =  *((unsigned long *)(*replaceWith + 8)) & ~mask;
					*(unsigned long *)(origContents + 8 ) = (*(unsigned long *)(origContents + 8)) & mask;
					*(unsigned long *)(*replaceWith + 8)= *((unsigned long *)(*replaceWith + 8)) | (*(unsigned long *)(origContents+ 8));
					break;
				case 2:
					//copy the first and second instn from the origcode
					**replaceWith = (*(unsigned long *)origContents);	
					mask = (~(unsigned long)0)<< 23;
					*(unsigned long *)(*replaceWith + 8) =  (unsigned long ) (*((unsigned long *)(*replaceWith + 8)) & mask);
					*(unsigned long *)(origContents + 8 ) = (*(unsigned long *)(origContents + 8)) & ~mask;
					*(unsigned long *)(*replaceWith + 8)= *((unsigned long *)(*replaceWith + 8)) | (*(unsigned long *)(origContents+ 8));
					break;
				default:
					//should never aris
					printf("\n Should never arise...wrong tag address obtained ??\n" );
					assert(0);
					break;	
			}
		}
	}
       return sizeOfInstns;
}



int replaceContents(Elf64_Shdr *shdr) //read the section of the external file and replace its annotated part.
{
        char * ptr;
        unsigned long retVal = 0;
        unsigned int i=0;
        unsigned int m_index= 0, sizeOfInsnts=0;
        unsigned long start_extFile = 0;
	unsigned long size = shdr->sh_size;
        uchar *replaceWith;
	printf("\n lseeking to %x ", shdr->sh_offset );
        retVal = lseek(origFileD, shdr->sh_offset, SEEK_SET);
        if(retVal < 0)
        {
                perror("\n Could not lseek to read the text section:");
		close(origFileD);
		close(replaceFileD);
                exit(0);
        }
	printf("\n lseek returned: %lx ", retVal);
        ptr = (char *) malloc(shdr->sh_size);
        if(NULL == ptr)
        {
                perror("\n Could not allocate memory for the ptr in replaceContents() because:");
		close(origFileD);
		close(replaceFileD);
                exit(0);
        }
        retVal = read(origFileD, ptr, shdr->sh_size);
        if(retVal < 0)
        {
		free(ptr);
                perror("\n Could not read the section because: ");
		close(origFileD);
		close(replaceFileD);
                exit(0);
        }
	printf("\n read %d bytes ", retVal);
	printf("\n Section size is : %lu ", shdr->sh_size);
        for(i=0; i<size; )
        {
                //start_extFile = 0x0a000000000000600; //start address of vmlinux
                retVal = prepareSensitiveInstn(&ptr, &m_index, &i) ;  //prepare the annotation for a macro in XEN to be replaced by neutral code
                printf("\n prepareSensitiveInstn returned : %lx ", retVal); 
                if(retVal != 0)
                {
                        if(m_index == 0)
                        {
                                assert(start_extFile == 0);
                                start_extFile = retVal;
                                printf("\n Start of external file is : %lx ", start_extFile);
                                continue; //case of "start"
                        }
                        else
                        {
				printf("\n m_index is : %d ", m_index);
				if(m_index == (NUM_MACROS - 1))
				{
					printf("\n Finished processing ! \n");
                        		close(origFileD);
		                        close(replaceFileD);
					return(0);
				}
				else
				{
					printf("\n prepareSensitiveInsnt returned %d ...asserting !\n", retVal);
                          	        assert(0);
				}
                        }
                }
                //annot.instns_with args replaced by the replacement num of args
                assert(m_index != 0);
		printf("\n m_index is : %d ", m_index);
		printf("\n before prepareReplacementCode----size of the section is : %lu and value of i is: %lu \n", shdr->sh_size, i);
                sizeOfInsnts = prepareReplacementCode(&replaceWith, m_index, start_extFile) ;
		printf("\n size of the section is : %lu and value of i is: %lu \n", shdr->sh_size, i);
		printf("\n Enter a key: ------ ");
		//we ignore the last two bits of the address of the instruction, to account for an address annotated by a [tag:] in which case the last
		//two bits indicate the slot number in the bundle
                if(lseekAndReplaceOriginalFile(replaceWith, origFileD, ((xenCurrentInstn_Annot.addr  & (~(unsigned long)0<<2))- start_extFile), sizeOfInsnts) < 0)
                {
                        printf("\n Could not replace the code !");
                        perror("because: ");
                        close(origFileD);
                        close(replaceFileD);
                        exit(0);
                }
		printf("\n size of the section is : %lu and value of i is: %lu ", shdr->sh_size, i);
	}
	printf("\n size of the section is : %lu and value of i is: %lu ", shdr->sh_size, i);
	printf("\n Scanned the entire section \n");
}

int main(int argc, char **argv)
{
	Elf64_Shdr shdr;
        if(4 != argc)
        {
                printf("\n Typical usage is replaceAnnotated <src section name > <fileName> <annotations section>\n");
                exit(0);
        }
	initDb();
	replaceFileD = readElfFile(argv[0], argv[1], O_RDONLY, &shdr); //read the neutral elf file which contains the replacement code
	getReplacementMacroAnnotation(&shdr); // the replacement code will appear only once. 
	origFileD = readElfFile(argv[2], argv[3], O_RDWR, &shdr); //read the original xen elf file
	printf("\n Preparing the replaceContents \n");
	replaceContents(&shdr); //for every annotated sensitive instruction in the shdr, perform the replacement.
	close(replaceFileD);
	close(origFileD);
	return(0);
}


