#.include "afterburner-xen/asm-xsi-offsets.h"

.globl initDb
.proc initDb
initDb::
.section "afterburn", "a", "progbits"
.asciz "epc"
.quad 1f
.quad 18
.quad 0 //num of args
.asciz "unepc"
.quad 2f
.quad 18 //length of the macro
.quad 0  //num of args in the macro
.asciz "ptr_i"
.quad 3f
.quad 1 //len of the macro
.quad 2 //num of args
.quad 1 //instn num in the macro having the args
.quad 0 //arg=SRC
.quad 0 // dummy start bit of the SRC
.quad 0 //dummy num of bits for the SRC
.quad 1 //arg=DSTN
.quad 1 //dummy start bit of the DSTN
.quad 1 //dummy num of bits for the DSTN
////////////////////////////////////////////////////////////
.asciz "write_itc"
.quad 4f
.quad 1 //len of the macro
.quad 2 //num of args
.quad 1 //instn num in the macro having the args
.quad 0 //arg=SRC
.quad 0 //dummy start bit for the SRC
.quad 0 //dummy num of bits for the SRC
.quad 1 //arg=DSTN
.quad 1 //dummy start bit for the DSTN
.quad 1 //dummy num of bits for the DSTN
////////////////////////////////////////////////////////////
.asciz "srlz_d"
.quad 5f
.quad 1 //len of the macro
.quad 0 //num of args
////////////////////////////////////////////////////////////
.asciz "srlz_i"
.quad 6f
.quad 1 //len of the macro
.quad 0 //num of args
////////////////////////////////////////////////////////////
.asciz "cover"
.quad 7f
.quad 3 //length of the macro
.quad 0 //num of args
////////////////////////////////////////////////////////////
.asciz "bsw_0"
.quad 9f
.quad 3 //length of the macro
.quad 0 //num of args
////////////////////////////////////////////////////////////
.asciz "bsw_1"
.quad 10f
.quad 3 //length of the macro
.quad 0 //num of args
////////////////////////////////////////////////////////////
.asciz "read_psr"
.quad 11f
.quad 4  //length of the macro
.quad 1  //num of arguments
.quad 1  //instn number in which the arg needs to be replaced
.quad 1  //type of arg = DSTN
.quad 6  //start bit of the arg
.quad 7  //num of bits of the arg
////////////////////////////////////////////////////////////
.asciz "thash"
.quad 12f
.quad 4 //size of the macro
.quad 2 //num of args
.quad 1 //instn num having the arg
.quad 0 //type of arg=SRC
.quad 20 
.quad 7
.quad 1 //type of arg = DSTN
.quad 6
.quad 7
////////////////////////////////////////////////////////////
.asciz "itc_d"
.quad 13f
.quad 4 //size of the macro
.quad 1 //num of args
.quad 1 //instn num having the arg
.quad 0 //type of arg is SRC
.quad 13
.quad 7
////////////////////////////////////////////////////////////
.asciz "rfi"
.quad 14f
.quad 1 // length of the macro
.quad 0 //num of args
////////////////////////////////////////////////////////////
.asciz "itc_i"
.quad 15f
.quad 4 //length of the macro
.quad 1 //num of args
.quad 1 //isntn num having the arg
.quad 0 //type of arg is SRC
.quad 13
.quad 7
////////////////////////////////////////////////////////////
.asciz "read_b2"
.quad 16f
.quad 4 //length of the macro
.quad 1 // num of args
.quad 2 //instn num having the arg
.quad 1 //type of the arg is DESTN
.quad 6
.quad 7
////////////////////////////////////////////////////////////
.asciz "write_b2"
.quad 17f
.quad 4 //len of macro
.quad 1 //num of args
.quad 2 //instn num in the macro
.quad 0 //type of arg
.quad 13
.quad 7
////////////////////////////////////////////////////////////
.asciz "st8_spill"
.quad 18f
.quad 6 //len of macro
.quad 3 //num of args
.quad 1 //instn in the macro having the arg
.quad 0 //type of arg is SRC
.quad 13
.quad 7
.quad 1  //type of arg is DST
.quad 20
.quad 7
.quad 2 //ICNR
.quad 9 //size of the INCR arg
.quad 6
.quad 7
.quad 27
.quad 1
.quad 36
.quad 1
////////////////////////////////////////////////////////////
.asciz "ld8_fill"
.quad 19f
.quad 6 //len of the macro
.quad 3 //num of args
.quad 1 //instn in the macro having the arg
.quad 1 //type of arg is DSTN
.quad 6
.quad 7
.quad 0 //type of arg is SRC
.quad 20
.quad 7 
.quad 2 //type of the arg is INCR
.quad 9
.quad 13
.quad 7
.quad 27
.quad 1
.quad 36
.quad 1
 ////////////////////////////////////////////////////////////
.asciz "ptc_e"
.quad 20f
.quad 1 //len
.quad 1 //num of args
.quad 1 //instn num in the macro having the arg
.quad 0 //arg=SRC
.quad 20 //start bit
.quad 7 // num of bits
////////////////////////////////////////////////////////////
.asciz "ptc_ga"
.quad 21f
.quad 7 //len of macro 
.quad 2 //num of args
.quad 1 //instn num in the macro
.quad 0 //SRC
.quad 13
.quad 7
.quad 1 //DSTN
.quad 20
.quad 7
////////////////////////////////////////////////////////////
.asciz "ptc_g"
.quad 22f
.quad 7 //len of macro 
.quad 2 //num of args
.quad 1 //instn num in the macro
.quad 0 //SRC
.quad 13
.quad 7
.quad 1 //DSTN
.quad 20
.quad 7
////////////////////////////////////////////////////////////
.asciz "ptc_l"
.quad 23f
.quad 7 //len of macro 
.quad 2 //num of args
.quad 1 //instn num in the macro
.quad 0 //SRC
.quad 13
.quad 7
.quad 1 //DSTN
.quad 20
.quad 7
////////////////////////////////////////////////////////////
.asciz "itr_i"
.quad 24f
.quad 7 //len of macro 
.quad 2 //num of args
.quad 1 //instn num in the macro
.quad 0 //SRC
.quad 13
.quad 7
.quad 1 //DSTN
.quad 20
.quad 7
////////////////////////////////////////////////////////////
.asciz "itr_d"
.quad 25f
.quad 7 //len of macro 
.quad 2 //num of args
.quad 1 //instn num in the macro
.quad 0 //SRC
.quad 13
.quad 7
.quad 1 //DSTN
.quad 20
.quad 7
////////////////////////////////////////////////////////////
.asciz "rsm"
.quad 26f
.quad 5 //max size of the macro
.quad 1  //num of args needing replacement
.quad 1  //instruction number having the argument which needs replacement
.quad 2  //type of argument to be replaced is INCR
.quad 24 //size of the INCR arg
.quad 6  //start bit
.quad 21 //num of bits
.quad 31 //start bit
.quad 2  //num of bits
.quad 36 //start bit
.quad 1  //num of bits -- 24 bits covered till here
////////////////////////////////////////////////////////////
.asciz "ssm"
.quad 27f
.quad 3 
.quad 1 //num of args
.quad 1 //instn num carrying the arg
.quad 2 //type of arg
.quad 24 //total bits in INCR arg
.quad 6
.quad 21
.quad 31
.quad 2
.quad 36
.quad 1
////////////////////////////////////////////////////////////
.asciz "write_psr"
.quad 28f
.quad 3 //len of arg
.quad 1 //num of args
.quad 1 //isntn havign the arg
.quad 0 //type of arg=SRC
.quad 13 
.quad 7
////////////////////////////////////////////////////////////
.asciz "write_rr"
.quad 29f
.quad 7 //len of macro
.quad 2 //num of args
.quad 1 //instn having the arg
.quad 0 //arg is SRC
.quad 13
.quad 7
.quad 1 //arg is DESTN
.quad 20
.quad 7
////////////////////////////////////////////////////////////
.asciz "read_rr"
.quad 30f
.quad 5 //len of macro
.quad 2 //num of args
.quad 1 //instn having the arg
.quad 0 //arg is SRC
.quad 20
.quad 7
.quad 1 //arg is DESTN
.quad 6
.quad 7
////////////////////////////////////////////////////////////
.asciz "write_cr"
.quad 31f
.quad 4
.quad 2 //num of args
.quad 1 //istn num having the args
.quad 0 //arg = SRC
.quad 13
.quad 7
.quad 1 //arg=DSTN
.quad 20
.quad 7
////////////////////////////////////////////////////////////
//in all the cases the number and type of instruction remains the same
.asciz "read_cr"
.quad  32f
.quad 4 //len of macro
.quad 2 //num of args
.quad 1 //instn having the args
.quad 0 //arg = SRC
.quad 20
.quad 7
.quad 1 //arg=DSTN
.quad 6
.quad 7
////////////////////////////////////////////////////////////
.asciz "write_kr"
.quad 33f
.quad 4 //len of the macro
.quad 2 //num of args
.quad 1 //instn num having the arg
.quad 0 //arg = SRC
.quad 13
.quad 7
.quad 1 //arg = DSTN
.quad 20
.quad 7 
////////////////////////////////////////////////////////////
.asciz "fc"
.quad 35f
.quad 4 //len of the macro
.quad 1 //num of args is 1
.quad 1 //instn num in the macro having the arg
.quad 0 //arg=SRC
.quad 20
.quad 7
////////////////////////////////////////////////////////////
.asciz "tpa"
.quad 36f
.quad 5 //len of the macro
.quad 2 //num of args is 2
.quad 1 //instn having the args
.quad 0 //arg = SRC
.quad 20
.quad 7
.quad 1 //arg = DSTN
.quad 6
.quad 7
////////////////////////////////////////////////////////////
.asciz "ptr_d"
.quad 37f
.quad 1  //len of the macro
.quad 2  //num of args
.quad 1 //instn num having the arg
.quad 0 //arg = SRC
.quad 0
.quad 0
.quad 1 //arg = DSTN
.quad 1
.quad 1
////////////////////////////////////////////////////////////
.asciz "read_kr"
.quad 34f
.quad 4  //length of the macro
.quad 2  //total num of args
.quad 1  //instruction num which requires replacement
.quad 0  //arg is SRC
.quad 20 //start bit num
.quad 7  //total num of bits.
.quad 1  //arg is DSTN
.quad 6  //start bit num
.quad 7  //total num of bits.
.asciz "end" //indicates that further on there are only  instructions
.align(16)
1:
{.mib
	nop 0
	nop 0
	epc         
}
{
	nop 0
	nop 0
	nop 0
}
{
	nop 0
	nop 0
	nop 0
}
{
	nop 0
	nop 0
	nop 0
}
{
	nop 0
	nop 0
	nop 0
}
{
	nop.m 0x0
	nop.m 0x0
	nop.i 0x0
}
2:
{
	nop 0
	nop 0
	nop 0
}
{
	nop 0
	nop 0
	nop 0
}
{
	nop 0
	nop 0
	nop 0
}
{
	nop 0
	nop 0
	nop 0
}
{
	nop 0
	nop 0
	nop 0
}
{
	nop.m 0x0
	nop.m 0x0
	nop.i 0x0
}
[3:]    (p0) ptr.i r2 , r3

[4:]    (p0) mov r2 = r1

[5:]    (p0) srlz.d 

[6:]    (p0) srlz.i


{.mib
	nop.m 0x0
	nop.i 0x0
        cover
7:}

{.mib
    (p0)  nop.m 0x0
    (p0)  nop.i 0x0
    (p0)  bsw.0
9:}

{.mib
    (p0)  nop.m 0x0
    (p0)  nop.i 0x0
    (p0) bsw.1	
10:}

{.mib
	(p0) mov r1 = psr //r1 = \dst
        (p0) nop.i 0x0
        (p0) nop.b 0x0
11:}
        (p0) nop.m 0x0

{.mii
 	(p0) thash r1 = r2 //r1 = \dst, r2=\src	
        (p0) nop.i 0x0
        (p0) nop.i 0x0
12:}
        (p0) nop.m 0x0

{.mmi
       (p0) itc.d r2
       (p0) nop.m 0x0
       (p0) nop.i 0x0
13:}
       (p0) nop.m 0x0

{.mib
	nop.m 0x0
	nop.i 0x0
[14:]	rfi	
}


{.mmi
       (p0) itc.i r2	
       (p0) nop.m 0x0
       (p0) nop.i 0x0
15:}
       (p0) nop.m 0x0

{.mii
	(p0) nop.m 0x0
	(p0) mov r1 = b2	
	(p0) nop.i 0x0
16:}
        (p0) nop.m 0x0

{.mii
    (p0) nop.m 0x0
    (p0) mov b2 = r2	
    (p0) nop.i 0x0
17:}
    (p0) nop.m 0x0

{.mmi
     (p0) st8.spill [r3] = r2, 250		 //idx=r3, 2=reg, incr = 1024
     (p0) nop.m 0x0
     (p0) nop.i 0x0
18:}
     (p0) nop.m 0x0
     (p0) nop.m 0x0
     (p0) nop.i 0x0

{.mmi
    (p0) ld8.fill r2 = [r3], 250
    (p0) nop.m 0x0
    (p0) nop.i 0x0
19:}
    (p0) nop.m 0x0
    (p0) nop.m 0x0
    (p0) nop.i 0x0

    (p0) ptc.e r2 // r2 = \src 	
[20:]

{.mmi
    (p0) ptc.ga r1, r2  	//r2 = \sz	r1=\va
    (p0) nop.m 0x0
    (p0) nop.i 0x0
21:
}
    (p0) nop.m 0x0
    (p0) nop.m 0x0
    (p0) nop.i 0x0
    (p0) nop.m 0x0

{.mmi
    (p0)  ptc.g r1, r2	
    (p0) nop.m 0x0
    (p0) nop.i 0x0
22:
}
    (p0) nop.m 0x0
    (p0) nop.m 0x0
    (p0) nop.i 0x0
    (p0) nop.m 0x0

{.mmi
    (p0) ptc.l r1, r2	
    (p0) nop.m 0x0
    (p0) nop.i 0x0
23:
}
    (p0) nop.m 0x0
    (p0) nop.m 0x0
    (p0) nop.i 0x0
    (p0) nop.m 0x0
////////////////////////////////////////////////////////////
{.mii
    (p0) itr.i itr[r2] = r1 	 // r2 = \itr , r1 = \src
    (p0) nop.i 0x0
    (p0) nop.i 0x0
24:
}
    (p0) nop.m 0x0
    (p0) nop.m 0x0
    (p0) nop.i 0x0
    (p0) nop.m 0x0

{.mii
    (p0) itr.d dtr[r2] = r1 //r1 = \src, r2 = \dtr
    (p0) nop.i 0x0
    (p0) nop.i 0x0
25:
} 
    (p0) nop.m 0x0
    (p0) nop.m 0x0
    (p0) nop.i 0x0
    (p0) nop.m 0x0

    (p0) rsm 3<<13	//dummy mask
    (p0) nop.m 0x0
    (p0) nop.i 0x0
26:
    (p0) nop.m 0x0
    (p0) nop.m 0x0

    (p0) ssm 3<<13	 //dummy mask
    (p0) nop.i 0x0
27: (p0) nop.b 0x0

{.mii
    (p0) mov psr.l=r1 //r1 = \src
    (p0) nop.i 0x0
    (p0) nop.i 0x0
28:}

{.mii
     (p0) mov rr[r2] = r1 //r1=\src, r2 = \rr	
     (p0) nop.i 0x0
     (p0) nop.i 0x0
29:}
     (p0) nop.m 0x0
     (p0) nop.i 0x0
     (p0) nop.i 0x0
     (p0) nop.m 0x0

{.mii
     (p0) mov r2 = rr[r3]	 // rr = r3, r2 = dst
     (p0) nop.i 0x0
     (p0) nop.i 0x0
30:}
     (p0) nop.m 0x0
     (p0) nop.i 0x0

{.mii
     (p0) mov cr2 = r1 //src = r1, 2=\cr
     (p0) nop.i 0x0
     (p0) nop.i 0x0
31:}
     (p0) nop.m 0x0

{.mii
     (p0) mov r2 = cr2 //2=\cr, dst=r2
     (p0) nop.i 0x0
     (p0) nop.i 0x0
32:
}
     (p0) nop.m 0x0

{.mmi
     (p0) mov ar2 = r1 //\src =r1, kr=2
     (p0) nop.m 0x0
     (p0) nop.i 0x0
33:
}
     (p0) nop.m 0x0

    (p0) mov r2 = ar2  //dst=r2, kr=2
    (p0) nop.i 0x0
    (p0) nop.i 0x0
    (p0) nop.m 0x0
34:

{.mii
    (p0) fc r2  //src = r2		
    (p0) nop.i 0x0
    (p0) nop.i 0x0
35:
}
    (p0) nop.m 0x0

{.mii
    (p0) tpa r1 = r2 //src=r2, dst=r1
    (p0) nop.i 0x0
    (p0) nop.i 0x0
36:
}
    (p0) nop.m 0x0
    (p0) nop.i 0x0

[37:](p0) ptr.d r2, r3 //sz = r3, va=r2 	
////////////////////////////////////////////////////////////
.previous
.previous
.previous
{.mib
nop.m 0x0
nop.i 0x0
nop.b 0x0
}
.endp initDb

