
#ifndef _WINDOWMANAGER_HPP_
#define _WINDOWMANAGER_HPP_

#include <X11/Xlib.h>
#include <string>

class WindowManager
{

	public:
		WindowManager();
		~WindowManager();
		void Frame(Window window);
		void Unframe(Window window);
		void OnCreateNotify(const XCreateWindowEvent& e);
		void OnDestroyNotify(const XDestroyWindowEvent& e);

	private:
		Display *display;
		Window root;
		int mouseX = -1;
		int mouseY = -1;
		int mouseButton;
		XEvent event;
};

#endif
