
#include "WindowManager.hpp"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <cstring>
#include <algorithm>
#include <iostream>
#include <stdio.h>
#include <glog/logging.h>

WindowManager::WindowManager()
{
	display = XOpenDisplay(NULL);
	if (display == NULL)
	{
		printf("Cannot connect to X server!\n");
		return;
	}

	root = XDefaultRootWindow(display);
	XGrabPointer(display, root, false, ButtonPressMask,
			GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
	XSelectInput(display, root, ButtonPressMask);

	// --- handle already created windows
	Window returned_root, returned_parent;
	Window* top_level_windows;
	unsigned int num_top_level_windows;
	CHECK(XQueryTree(display, root, &returned_root, &returned_parent, 
				&top_level_windows, &num_top_level_windows));
	CHECK_EQ(returned_root, root);
	for(unsigned int i = 0; i < num_top_level_windows; ++i)
	{
		Frame(top_level_windows[i]);
	}

	XFree(top_level_windows);

	while(1)
	{
		XNextEvent(display, &event);
		switch(event.type)
		{
			case ButtonPress:
				switch(event.xbutton.button)
				{
					case Button1:
						mouseX = event.xbutton.x;
						mouseY = event.xbutton.y;
						mouseButton = Button1;
						break;
					case Button3:
						mouseX = event.xbutton.x;
						mouseY = event.xbutton.y;
						mouseButton = Button3;
						break;
					default:
						break;
				}
				printf("Mouse press");
				break;
			case CreateNotify:
				OnCreateNotify(event.xcreatewindow);
				break;
			case DestroyNotify:
				OnDestroyNotify(event.xdestroywindow);
				break;
			default:
				break;	
		}
	}
}

WindowManager::~WindowManager()
{
	XCloseDisplay(display);
}

void WindowManager::Frame(Window window)
{
	const unsigned int BORDER_WIDTH = 3;
	const unsigned int BORDER_COLOR = 0xFF4242;
	const unsigned int BG_COLOR     = 0xc0c0c0;

	XWindowAttributes x_window_attrs;
	CHECK(XGetWindowAttributes(display, window, &x_window_attrs));

	const Window window_border = XCreateSimpleWindow(
		display, root, x_window_attrs.x, x_window_attrs.y, 
		x_window_attrs.width, x_window_attrs.height, BORDER_WIDTH,
		BORDER_COLOR, BG_COLOR);

	const Window window_titlebar = XCreateSimpleWindow(
		display, window_border, 0, 0, x_window_attrs.width, 20, BORDER_WIDTH,
		BORDER_COLOR, BG_COLOR);

	XSelectInput(display, window_border, 
		SubstructureRedirectMask | SubstructureNotifyMask);
//	XSelectInput(display, window_titlebar,
//		ButtonPressMask);

	XAddToSaveSet(display, window);
	XReparentWindow(display, window, window_border, 0, 20);

	XMapWindow(display, window_border);
	XMapWindow(display, window_titlebar);

	//TODO(noah): Remove this and replace with better mouse listener
	XGrabPointer(display, window_titlebar, 1, 
			ButtonPressMask | ButtonReleaseMask | PointerMotionMask,
			GrabModeAsync, GrabModeAsync, None, None, CurrentTime);

	std::cout << "Framed window " << window << " [" << window_border 
		<< "]" << std::endl;
}

void WindowManager::Unframe(Window window)
{

}

void WindowManager::OnCreateNotify(const XCreateWindowEvent& e)
{

}

void WindowManager::OnDestroyNotify(const XDestroyWindowEvent& e)
{

}
